import { Link, useLocation } from 'react-router-dom'
import { BookOpen } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-split">
      <header className="header-split">
        <div className="container">
          <div className="header-content-split">
            <Link to="/" className="logo-split">
              <div className="logo-icon-wrapper-split">
                <BookOpen className="logo-icon-split" size={28} />
              </div>
              <span className="logo-text-split">Академия</span>
            </Link>
            <nav className="nav-split">
              <Link 
                to="/" 
                className={`nav-link-split ${location.pathname === '/' ? 'active' : ''}`}
              >
                Заявки
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-split ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-split">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout
